
// dc.44.c
//
// solar tracker motor drive
//
// Babken Chugaszyan
// 19/06/2019
//
// (c)This work may be reproduced, modified, distributed, performed,
// and displayed for any purpose. No warranty is provided, and users accept all 
// liability.
//

#include <avr/io.h>
#include <util/delay.h>

#define output(directions,pin) (directions |= pin) // set port direction for output
#define input(directions,pin) (directions &= (~pin)) // set port direction for input
#define set(port,pin) (port |= pin) // set port pin
#define clear(port,pin) (port &= (~pin)) // clear port pin
#define pin_test(pins,pin) (pins & pin) // test for port pin
#define bit_test(byte,bit) (byte & (1 << bit)) // test for bit set

#define input_port PORTB
#define input_direction DDRB
#define input_pino (1 << PB0)
#define input_pini (1 << PB1)
#define input_pins PINB

#define bridge_port PORTA // H-bridge port
#define bridge_direction DDRA // H-bridge direction
#define IN1 (1 << PA0) // IN1
#define IN2 (1 << PA1) // IN2
#define IN3 (1 << PA3) // IN3
#define IN4 (1 << PA4) // IN4

int main(void) {
   //
   // main
   //
   
   //
   // set clock divider to /1
   //
   CLKPR = (1 << CLKPCE);  // enable a change to CLKPR
   CLKPR = (0 << CLKPS3) | (0 << CLKPS2) | (0 << CLKPS1) | (0 << CLKPS0);
   //
   // initialize H-bridge pins
   //
   clear(bridge_port, IN1);
   output(bridge_direction, IN1);
   clear(bridge_port, IN2);
   output(bridge_direction, IN2);
   clear(bridge_port, IN3);
   output(bridge_direction, IN3);
   clear(bridge_port, IN4);
   output(bridge_direction, IN4);

   set(input_port, input_pino); // turn on pull-up
   set(input_port, input_pini);
   input(input_direction, input_pino);
   input(input_direction, input_pini);
   //
   // main loop
   //
   while (1) {  

     if (0 != pin_test(input_pins,input_pino))
      {
      clear(bridge_port, IN1);//left
      set(bridge_port, IN2);
      }
     else {
      clear(bridge_port, IN2);//right
      set(bridge_port, IN1);
      }
     if (0 != pin_test(input_pins,input_pini))
      {
      clear(bridge_port, IN3);//up
      set(bridge_port, IN4);
      }
     else {
      clear(bridge_port, IN4);//down
      set(bridge_port, IN3);

  }
      }
   }
